-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" );
DebugOut("ChoosePlayer");


function ShowSubmitOptions( show )
	EnableWindow( "delete", show )
	EnableWindow( "chooseok", show )
	EnableWindow( "editname", show )
	EnableWindow( "txtDeletePlayer",show)
end

function ShowCreateOptions( show )
	EnableWindow( "newplayer", show )
	EnableWindow( "textnewplayer", show )
end

function UpdatePlayerChoices( curUser, numUsers, userTable )

	if (numUsers >= kMaxUsers) then
		ShowCreateOptions(false)
	else
		ShowCreateOptions(true)
	end

	if (numUsers==0) then
		ShowSubmitOptions( false )
	else
		ShowSubmitOptions( true )
	end

	for i = 0,numUsers-1 do
		SetLabel( "button"..i, userTable[ i+1 ] );
		EnableWindow( "button"..i, true ) ;
	end

	for i = numUsers, kMaxUsers do
		EnableWindow( "button"..i, false ) ;
	end

	if numUsers>0 then
		SetButtonToggleState( "button"..curUser, true );
	end

	DebugOut("UpdatePlayerChoices");
end

NameFont = {
  standardFont,
  20,
  AquaColor
};

ButtonX = kCenter;
ButtonY = 115	;
ButtonYSpace = 35;
XButtonSpace = 90;
YButtonSpace = 55;
kButtonLineX1 = 230;
kButtonLineX2 = 250;
kButtonLineY1 = 420;
kButtonLineY2 = 340;
kMaxUsers = 10;
kTextButton		= 30;

NameButtonGraphics = {
	"images/ui/buttons/but73",
	"images/ui/buttons/but72",
	"images/ui/buttons/but73",
	"images/ui/buttons/but72"
};	

NameStyle= {    
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

--gSelected = -1 ;

function AddButtons( N )

	t = { SetStyle(NameStyle), BeginGroup() };

	for i = 0,N-1 do
		table.insert(t,
			Button{
				name="button"..i,
--				command=function() gSelected = i; end,
				label="#name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
				mask = "images/ui/buttons/but72_mask",
			}
		);	
	end

	return Group(t);
end

MakeDialog
{
	-- Name the modal dialog
	name="chooseplayer",
	
	Bitmap
	{ 
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
	
		Bitmap
		{ 
			image="images/ui/common/popup05",
			x=kCenter,
			y=kCenter,
			
			ChoosePlayerWindow
			{
				x = 0, y = 0, w=kMax, h=kMax,
				
				Text
				{
					font = PopupFont,
					name = "selectaplayer",
					x=0,y=50,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "selectaplayer"
				};
				
				AddButtons( kMaxUsers );
				
				SetStyle(FitnessButtonStyleTittleSmallBlue2);
	--New Player
				SBButton
				{
					x=kButtonLineX1 + XButtonSpace,
					y=kButtonLineY1+YButtonSpace,
					name="newplayer",
					label="newplayer",
					icon="assets/images/ui/buttons/icon/iconplayer",
					command =
						function()
							gEnterNameValue = "";
							name = DoModal("scripts/entername.lua");
							if (not(name == nil)) then
								CreateNewUser(name);
								SetPlayerChoices()
							end
						end
				};
			
		--Edit			
				SBButton
				{
					x=kButtonLineX1+3*XButtonSpace,
					y=kButtonLineY1+YButtonSpace,
					name="editname",
					label="editname",				
					icon="assets/images/ui/buttons/icon/iconedit",
					
					command =
						function()
							gEnterNameValue = GetSelectedPlayerName();
							name = DoModal("scripts/entername.lua");
							if (not(name == nil)) then
								SetCurrentUser(GetCurrentSelectedUser());
								ChangeCurrentUserName(name);
								SetPlayerChoices();
								SetWelcomeName();
							end
						end
				};

	--OK
				SBButton
				{
					x=kButtonLineX1 + 0*XButtonSpace,
					y=kButtonLineY1+YButtonSpace,
					name="chooseok",
					label="common.ok.label",
					icon="assets/images/ui/buttons/icon/iconplay",
					
					command = 
						function()
							SetCurrentUser(GetCurrentSelectedUser());
							SetWelcomeName();
							PopModal("chooseplayer");
						end
				};
				SetStyle(FitnessButtonStyleTittleSmallBlue);
		--Delete Player
				SBButton
				{
					flags = kHAlignCenter + kVAlignCenter,
					x=kButtonLineX1+2*XButtonSpace,
					y=kButtonLineY1+YButtonSpace,
					name="delete",
					icon="assets/images/ui/buttons/icon/icondeleteplayer",

					command =
						function()
							result = DisplayDialog { 
								"scripts/yesno.lua", 
								body ="deleteconfirm",
								title = "deletetitle" 
							};
							if (result=='yes') then
								DeleteUser(GetCurrentSelectedUser())
								SetPlayerChoices()
							end
						end
					
				};
				
				Text
				{
					name = "txtDeletePlayer",
					font = SmallFont,
					x=kButtonLineX1+ 2*XButtonSpace - 18,
					y=kButtonLineY1+YButtonSpace+30,
					w=100,
					flags = kHAlignCenter + kVAlignCenter,				
					label="deleteplayer",
				};
			}
		}
	}
}


--UpdatePlayerChoices( 0,0, {} );

--SetPlayerChoices();

